<?php
	include_once('/home/USERNAME/includes/fields.phpi');
	$imaginaries = array(
		'rabbit'=>'The White Rabbit',
		'scarecrow'=>'The Scarecrow',
		'tinman'=>'The Tin Man',
		'neo'=>'Neo',
	);
	$vote = new VoteCounter('character', $imaginaries);
	$vote->save();
?>
<!doctype html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<title>Best Imaginary Character</title>
		<style>
			body {
				margin: 10em;
				padding: 2em;
				border: solid .2em green;
			}
			h1 {
				text-align: center;
			}
			th {
				text-align: right;
			}
		</style>
	</head>
	<body>
		<h1>Imaginary Fight to the Finish</h1>

		<?php IF ($vote->answered()):?>
			<p>Thank you for voting for <?php echo $vote->name(); ?>!</p>
			<p>The current results are:</p>
			<table>
				<?php FOREACH ($vote->counts() as $choice=>$count):?>
					<tr>
						<th><?php echo $vote->choiceName($choice); ?></th>
						<td><?php echo $count; ?></td>
					</tr>
				<?php ENDFOREACH;?>
			</table>
		<?php ELSE:?>
			<form method="post" action="poll-session.php">
				<p>
					Please choose your favorite imaginary imaginary character:
					<?php echo $vote->formSelect(); ?>
					<input type="submit" value="Submit your answer" />
				</p>
			</form>
		<?php ENDIF;?>
	</body>
</html>
